package gov.va.vinci.dart.db;

import gov.va.vinci.dart.biz.Comment;
import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.NestableComment;
import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestCommentDAO extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}
	
	@Test
	public void testOne() throws Exception {
		Comment comment = DartObjectFactory.getInstance().getCommentDAO().findById(-1);
		Assert.assertNull(comment);

		List<DartRequest> rlist = DartObjectFactory.getInstance().getDartRequestDAO().listAll();
		Assert.assertNotNull(rlist);
		Assert.assertTrue(rlist.size() > 0);

		DartRequest request = rlist.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);
		Assert.assertNotNull(request.getActivity());
		Assert.assertTrue(request.getActivity().getId() > 0);
		
		comment = Comment.create("test description", request, "DNS", "test comment text");
		
		Assert.assertNotNull(comment);
		Assert.assertTrue(comment.getId() > 0);

		Comment c2 = DartObjectFactory.getInstance().getCommentDAO().findById(comment.getId());
		Assert.assertNotNull(c2);
		Assert.assertTrue(c2.getId() > 0);
		Assert.assertEquals(c2,comment);
		
		List<Comment> cList = DartObjectFactory.getInstance().getCommentDAO().listByActivityId(request.getActivity().getId());
		Assert.assertNotNull(cList);
		Assert.assertTrue(cList.size() > 0);
		Assert.assertTrue(cList.contains(comment));
		
		List<NestableComment> ncList = DartObjectFactory.getInstance().getCommentDAO().listByRequestId(request.getId());
		Assert.assertNotNull(ncList);
		Assert.assertTrue(ncList.size() > 0);
		
	}
}
